#include "BluetoothSerial.h"
#include "esp_bt_main.h"
#include "esp_bt_device.h"
#include "AS726X.h"
AS726X sensor;

String  data;
String  dataON;
String  dataOFF;
#if !defined(CONFIG_BT_ENABLED) || !defined(CONFIG_BLUEDROID_ENABLED)
#error Bluetooth is not enabled! Please run `make menuconfig` to and enable it
#endif

BluetoothSerial SerialBT;
void printDeviceAddress() {

const uint8_t* point = esp_bt_dev_get_address();

for (int i = 0; i < 6; i++) {
   char str[3];
   sprintf(str, "%02X", (int)point[i]);
   Serial.print(str);
   if (i < 5){
   Serial.print(":");}
}
Serial.println();
}
int addr ;
void setup()
{
  
Wire.begin();
  
data = "";


Serial.begin(9600);
delay(500);

pinMode(2, OUTPUT);
 sensor.begin();

 
  SerialBT.begin("ESP32_Agamy");
  Serial.println("This is your address");
  printDeviceAddress();
  
}


void loop()
{

sensor.setBulbCurrent(0);
sensor.setIntegrationTime(200);
sensor.setMeasurementMode(2);
sensor.setGain(0);
sensor.takeMeasurementsWithBulb();

 // T=sensor.getTemperatureF();
  float R = sensor.getCalibratedRed();
  float B = sensor.getCalibratedBlue();
  float G = sensor.getCalibratedGreen();
  float V = sensor.getCalibratedViolet();
  float O = sensor.getCalibratedOrange();
  float Y = sensor.getCalibratedYellow();

 float out1[] = {0   ,47, 0    ,55,38      ,61,63,121,120   ,176,204   ,229,223,229,246};
 float in1[]  = {2.69,134,146,155,159.78,173,197  ,220,306.99,461,489.21,723,726,758,780};
 float val1 = R;
 float  RR = multiMap(val1, in1, out1, 15);

 float out2[] = {0 ,52,49  ,  70,65,68 ,107   ,82 ,93  ,88 ,130   ,132  ,118,146,169   ,182,195   ,195 ,224    ,251};
 float in2[]= {6.87,84,104.22,113,117,170,176.36,192,208,267,295.47,308.07,454,529,576.05,627,973.44,1008,1037.57,1370.83};
 float val2 = G;
 float  GG = multiMap(val2, in2, out2, 20);

 float out3[]={0   ,53,60  ,58   ,80 ,130,101,61,68 ,148,139   ,30  ,31,112,127,162   ,180   ,180,99 ,36,100,173   ,180   ,220   ,255};
 float in3[]= {5.22,97,139 ,152 ,156,159,167,191,211,258,271.51,274,326,349,375,454.25,489.49,495,496,503,506,616.11,736.20,882.40,1156.51};
 float val3 =B;
 float  BB = multiMap(val3, in3, out3, 25);

 Serial.print(String((int)R) + ',' + String((int)G) + ',' + String((int)B)+"###"+String((int)V) + ',' + String((int)O) + ',' + String((int)Y));
 Serial.print(" ------------------- ");
 Serial.print(String((int)RR) + ',' + String((int)GG) + ',' + String((int)BB));
 Serial.println(' ');



//convert RGB to XYz

  double f1 = (RR / 255.000000);
  double f2 = (GG / 255.00000);
  double f3 = (BB / 255.00000);

  if ( f1 > 0.04045 ) {
    f1 = pow( ( ( f1 + 0.0550 ) / 1.0550 ) , 2.4000);
  }
  else              {
    f1 = f1 / 12.9200;
  }
  if ( f2 > 0.04045 ) {
    f2 = pow( ( ( f2 + 0.0550 ) / 1.0550 ) , 2.4000);
  }
  else             {
    f2 = f2 / 12.9200;
  }
  if ( f3 > 0.04045 ) {
    f3 = pow( ( ( f3 + 0.055 ) / 1.055 ) , 2.4000);
  }
  else{
    f3 = f3 / 12.9200;
      }
  
  f1 = f1 * 100;
  f2 = f2 * 100;
  f3 = f3 * 100;

  double x = ((f1 * 0.4124 ) + (f2 * 0.3576) + (f3 * 0.1805));
  double y = ((f1 * 0.2126 ) + ( f2 * 0.7152) + (f3 * 0.0722));
  double z = ((f1 * 0.0193 ) + (f2 * 0.1192 ) + (f3 * 0.9505));

  //double x = ((f1* 0.4124 )+ (f2 * 0.3576) +(f3 * 0.1805))*0.7562;
  //double y= ((f1 * 0.2126 )+( f2 * 0.7152) + (f3 * 0.0722))*0.7506;
  //double z= ((f1 * 0.0193 )+ (f2 * 0.1192 )+ (f3 * 0.9505))*0.7883;

  //convert XYZ to LAB 

  double var_X = x / 95;
  double var_Y = y / 100;
  double var_Z = z / 108;

  if ( var_X > 0.008856 ) {
    var_X = pow( var_X , ( 0.3333333333 ));
  }
  else                  {
    var_X = ( 7.7870 * var_X ) + ( 16.0 / 116.0 );
  }
  if ( var_Y > 0.008856 ) {
    var_Y = pow (var_Y , ( 0.3333333333 ));
  }
  else                    {
    var_Y = ( 7.7870 * var_Y ) + ( 16.0 / 116.0 );
  }
  if ( var_Z > 0.008856 ) {
    var_Z = pow (var_Z , ( 0.3333333333 ));
  }
  else                    {
    var_Z = ( 7.7870 * var_Z ) + ( 16.0 / 116.0 );
  }

  double l = ( 116 * var_Y ) - 16;
  double a = 500 * ( var_X - var_Y );
  double b = 200 * ( var_Y - var_Z );

  //convert XYZ to LCH

  double h =  atan2  ( b, a);
  if ( h > 0 ) {
    h = ( h / PI ) * 180;
  }
  else             h = 360 - ( abs( h ) / PI ) * 180;
  double c = sqrt( pow (a, 2) + pow(b, 2) );


  
 //convert RGB to CMYK
 
  float R_dot = (RR / 255.00);
  float G_dot = (GG / 255.00);
  float B_dot = (BB / 255.00);
  float maxRG= max(R_dot,G_dot);
float Kx=(1-max(maxRG,B_dot));


float Cx = (1-R_dot-Kx) / ( 1-Kx) ;
float Yx = ( 1-B_dot-Kx) / ( 1-Kx) ;
float Mx = (1-G_dot-Kx) /(  1-Kx);

int Cperc = Cx * 100;
int Mperc = Mx * 100;
int Yperc = Yx * 100;
int Kperc = Kx * 100;

 //convert RGB to HSL

int Hx;
float Sx;
float Lx;
int temp1;
float S;
float Cmax=max(max(R_dot,G_dot),B_dot);
float Cmin=min(min(R_dot,G_dot),B_dot);
float Delta=Cmax-Cmin;

if(Cmax==R_dot)
{
  temp1=(G_dot-B_dot)/Delta;
  Hx=(60*(temp1%6));
  }
if(Cmax==G_dot)
{Hx=(60*(((B_dot-R_dot)/Delta)+2));}
if(Cmax==B_dot)
{Hx=(60*(((R_dot-G_dot)/Delta)+4));}

Lx=(Cmax+Cmin)/2;

if(Delta==0)
{Hx=0;
Sx=0;
}
else
{Sx=Delta/(1-abs((2*Lx)-1));}


//convert RGB to HSV

if(Cmax==0)
{S=0;}
else
{S=Delta/Cmax;}
float Vx=Cmax;

int Sxperc=Sx*100;
int Lperc=Lx*100;
int Sperc=S*100;
int Vperc=Vx*100;


//sending the fram to the mobile APP

//Serial.println(String((int)RR) + ',' + String((int)GG) + ',' + String((int)BB) + ',' + String((double)x) + ',' + String((double)y) + ',' + String((double)z) + ',' + String((double)l) + ',' + String((double)a) + ',' + String((double)b) + ',' + String((double)c) + ',' + String((double)h) + ','+String((double)Cperc) + ',' + String((double)Mperc) + ',' + String((double)Yperc) + ',' + String((double)Kperc) + ',' + String((int)Hx) + ',' + String((int)Sxperc) + ',' + String((int)Lperc) + ',' + String((int)Sperc) + ',' + String((int)Vperc) + ',');
SerialBT.println(String((int)RR) + ',' + String((int)GG) + ',' + String((int)BB) + ',' + String((double)x) + ',' + String((double)y) + ',' + String((double)z) + ',' + String((double)l) + ',' + String((double)a) + ',' + String((double)b) + ',' + String((double)c) + ',' + String((double)h) + ','+String((double)Cperc) + ',' + String((double)Mperc) + ',' + String((double)Yperc) + ',' + String((double)Kperc) + ',' + String((int)Hx) + ',' + String((int)Sxperc) + ',' + String((int)Lperc) + ',' + String((int)Sperc) + ',' + String((int)Vperc) + ',');
      
   
      }

// the Lookup table multiMap function 
      
float multiMap(float val, float* _in, float* _out, uint8_t size)
{
 uint8_t pos = 1;
 if(_in[0] < _in[1]) {
   if (val <= _in[0]) return _out[0];
   if (val >= _in[size-1]) return _out[size-1];
   if (val == _in[pos]) return _out[pos];
   while(val > _in[pos]) pos++;
 } else {
   if (val >= _in[0]) return _out[0];
   if (val <= _in[size-1]) return _out[size-1];
   if (val == _in[pos]) return _out[pos];
   while(val < _in[pos]) pos++;
 }
 // interpolate in the right segment for the rest
 return map(val, _in[pos-1], _in[pos], _out[pos-1], _out[pos]);
}
